;*****************************************************************************
;*                                                                           *
;*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Title      : 6809 Emulator code PULS instruction code                   *
;*                                                                           *
;*   File Name  : pulu6809.ASM                                               *
;*                                                                           *
;*   Author     : Keith Wilkins                                              *
;*                                                                           *
;*   Version    : 1.00                                                       *
;*                                                                           *
;*   Desciption : This file contains the code to emulate the PULS instruction*
;*                a jump table is used to decode the register combinations   *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Revision History:                                                       *
;*                                                                           *
;*   Version    Date    Who  Description of changes                          *
;*   -------    ----    ---  ----------------------                          *
;*                                                                           *
;*    0.01    22/11/95  K.W  Creation of empty stub file, description only   *
;*    1.00    06/08/96  K.W  Public release of DVE 1.0                       *
;*                                                                           *
;*****************************************************************************

extern _f6809AddressRead:near
extern _f6809AddressWrite:near
extern _apfWriteHandlers:near
extern _apfReadHandlers:near
extern _Idx6809JumpTable:near
extern f6809cctodl_:near
extern f6809dltocc_:near

include "reg6809.h"
include "mac6809.h"

_PULU6809_TEXT segment dword public 'CODE'
               assume  CS:_PULU6809_TEXT



;
; Define local PUSH macros
;
mpull_cc MACRO
   m_fetch08
   inc     bx
   call    f6809dltocc_
ENDM

mpull_a MACRO
  m_fetch08
  inc     bx
  mov     [R6809_A],dl
ENDM

mpull_b MACRO
  m_fetch08
  inc     bx
  mov     [R6809_B],dl
ENDM

mpull_dp MACRO
  m_fetch08
  inc     bx
  mov     [R6809_DP],dl
ENDM

mpull_x MACRO
  m_fetch08
  inc     bx
  mov     [R6809_X+1],dl

  m_fetch08
  inc     bx
  mov     [R6809_X],dl
ENDM

mpull_y MACRO
  m_fetch08
  inc     bx
  mov     [R6809_Y+1],dl

  m_fetch08
  inc     bx
  mov     [R6809_Y],dl
ENDM

mpull_s MACRO
  m_fetch08
  inc     bx
  mov     [R6809_HSP+1],dl

  m_fetch08
  inc     bx
  mov     [R6809_HSP],dl
ENDM

mpull_pc MACRO
  m_fetch08
  inc     bx
  mov     [R6809_PC+1],dl

  m_fetch08
  inc     bx
  mov     [R6809_PC],dl
ENDM




; Template
;
; CC,A,B,DP,X,Y,U,PC
;
;pulu6809_xx    PROC    near
;               mov     bx,[R6809_USP]
;               mpull_cc
;               mpull_a
;               mpull_b
;               mpull_dp
;               mpull_x
;               mpull_y
;               mpull_s
;               mpull_pc
;               mov     [R6809_USP],bx
;               mov     ax,0x0ZZ
;               ret
;pulu6809_xx    ENDP






;
; CPU Exception
;
pulu6809_EX    PROC    near

               add     sp,4               ; Remove return address
               mov     ax,CPU_EXCEPTION
               m_exit
               ret

pulu6809_EX    ENDP








;
;
; START OF CODE
;
; Note AX always returns number of cycles.
;



;*************************************
;
;             0x00
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_00    PROC    near
               mov     ax,0x00
               ret
pulu6809_00    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_01    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mov     [R6809_USP],bx
               mov     ax,0x01
               ret
pulu6809_01    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_02    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mov     [R6809_USP],bx
               mov     ax,0x01
               ret
pulu6809_02    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_03    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pulu6809_03    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_04    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mov     [R6809_USP],bx
               mov     ax,0x01
               ret
pulu6809_04    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_05    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pulu6809_05    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_06    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pulu6809_06    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_07    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_07    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_08    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mov     [R6809_USP],bx
               mov     ax,0x01
               ret
pulu6809_08    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_09    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pulu6809_09    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_0A    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pulu6809_0A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_0B    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_0B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_0C    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pulu6809_0C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_0D    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_0D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_0E    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_0E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_0F    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_0F    ENDP







;*************************************
;
;             0x10
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_10    PROC    near
               mov     bx,[R6809_USP]
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pulu6809_10    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_11    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_11    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_12    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_12    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_13    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_13    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_14    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_14    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_15    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_15    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_16    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_16    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_17    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_17    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_18    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_18    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_19    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_19    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_1A    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_1A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_1B    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_1B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_1C    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_1C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_1D    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_1D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_1E    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_1E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_1F    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_1F    ENDP








;*************************************
;
;             0x20
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_20    PROC    near
               mov     bx,[R6809_USP]
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pulu6809_20    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_21    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_21    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_22    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_22    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_23    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_23    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_24    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_24    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_25    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_25    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_26    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_26    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_27    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_27    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_28    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_28    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_29    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_29    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_2A    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_2A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_2B    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_2B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_2C    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_2C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_2D    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_2D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_2E    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_2E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_2F    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_2F    ENDP








;*************************************
;
;             0x30
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_30    PROC    near
               mov     bx,[R6809_USP]
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_30    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_31    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_31    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_32    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_32    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_33    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_33    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_34    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_34    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_35    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_35    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_36    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_36    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_37    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_37    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_38    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_38    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_39    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_39    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_3A    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_3A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_3B    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_3B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_3C    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_3C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_3D    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_3D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_3E    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_3E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_3F    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_3F    ENDP








;*************************************
;
;             0x40
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_40    PROC    near
               mov     bx,[R6809_USP]
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pulu6809_40    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_41    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_41    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_42    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_42    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_43    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_43    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_44    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_44    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_45    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_45    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_46    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_46    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_47    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_47    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_48    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_48    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_49    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_49    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_4A    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_4A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_4B    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_4B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_4C    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_4C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_4D    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_4D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_4E    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_4E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_4F    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_4F    ENDP








;*************************************
;
;             0x50
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_50    PROC    near
               mov     bx,[R6809_USP]
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_50    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_51    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_51    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_52    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_52    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_53    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_53    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_54    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_54    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_55    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_55    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_56    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_56    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_57    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_57    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_58    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_58    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_59    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_59    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_5A    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_5A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_5B    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_5B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_5C    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_5C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_5D    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_5D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_5E    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_5E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_5F    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_5F    ENDP








;*************************************
;
;             0x60
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_60    PROC    near
               mov     bx,[R6809_USP]
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_60    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_61    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_61    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_62    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_62    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_63    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_63    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_64    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_64    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_65    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_65    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_66    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_66    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_67    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_67    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_68    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_68    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_69    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_69    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_6A    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_6A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_6B    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_6B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_6C    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_6C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_6D    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_6D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_6E    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_6E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_6F    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_6F    ENDP








;*************************************
;
;             0x70
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_70    PROC    near
               mov     bx,[R6809_USP]
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_70    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_71    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_71    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_72    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_72    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_73    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_73    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_74    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_74    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_75    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_75    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_76    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_76    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_77    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_77    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_78    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_78    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_79    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_79    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_7A    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_7A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_7B    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_7B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_7C    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_7C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_7D    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_7D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_7E    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_7E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_7F    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mov     [R6809_USP],bx
               mov     ax,0x0A
               ret
pulu6809_7F    ENDP








;*************************************
;
;             0x80
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_80    PROC    near
               mov     bx,[R6809_USP]
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x02
               ret
pulu6809_80    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_81    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_81    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_82    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_82    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_83    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_83    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_84    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_84    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_85    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_85    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_86    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_86    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_87    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_87    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_88    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x03
               ret
pulu6809_88    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_89    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_89    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_8A    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_8A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_8B    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_8B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_8C    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_8C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_8D    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_8D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_8E    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_8E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_8F    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_8F    ENDP








;*************************************
;
;             0x90
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_90    PROC    near
               mov     bx,[R6809_USP]
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_90    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_91    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_91    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_92    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_92    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_93    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_93    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_94    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_94    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_95    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_95    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_96    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_96    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_97    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_97    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_98    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_98    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_99    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_99    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_9A    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_9A    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_9B    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_9B    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_9C    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_9C    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_9D    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_9D    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_9E    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_9E    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_9F    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_9F    ENDP








;*************************************
;
;             0xA0
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_A0    PROC    near
               mov     bx,[R6809_USP]
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_A0    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_A1    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_A1    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_A2    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_A2    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_A3    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_A3    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_A4    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_A4    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_A5    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_A5    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_A6    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_A6    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_A7    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_A7    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_A8    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_A8    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_A9    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_A9    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_AA    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_AA    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_AB    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_AB    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_AC    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_AC    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_AD    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_AD    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_AE    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_AE    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_AF    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_AF    ENDP








;*************************************
;
;             0xB0
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_B0    PROC    near
               mov     bx,[R6809_USP]
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_B0    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_B1    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_B1    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_B2    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_B2    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_B3    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_B3    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_B4    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_B4    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_B5    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_B5    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_B6    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_B6    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_B7    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_B7    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_B8    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_B8    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_B9    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_B9    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_BA    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_BA    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_BB    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_BB    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_BC    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_BC    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_BD    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_BD    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_BE    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_BE    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_BF    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pulu6809_BF    ENDP








;*************************************
;
;             0xC0
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_C0    PROC    near
               mov     bx,[R6809_USP]
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x04
               ret
pulu6809_C0    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_C1    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_C1    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_C2    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_C2    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_C3    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_C3    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_C4    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_C4    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_C5    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_C5    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_C6    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_C6    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_C7    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_C7    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_C8    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x05
               ret
pulu6809_C8    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_C9    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_C9    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_CA    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_CA    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_CB    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_CB    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_CC    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_CC    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_CD    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_CD    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_CE    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_CE    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_CF    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_CF    ENDP








;*************************************
;
;             0xD0
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_D0    PROC    near
               mov     bx,[R6809_USP]
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_D0    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_D1    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_D1    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_D2    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_D2    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_D3    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_D3    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_D4    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_D4    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_D5    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_D5    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_D6    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_D6    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_D7    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_D7    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_D8    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_D8    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_D9    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_D9    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_DA    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_DA    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_DB    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_DB    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_DC    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_DC    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_DD    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_DD    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_DE    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_DE    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_DF    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pulu6809_DF    ENDP








;*************************************
;
;             0xE0
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_E0    PROC    near
               mov     bx,[R6809_USP]
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x06
               ret
pulu6809_E0    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_E1    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_E1    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_E2    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_E2    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_E3    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_E3    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_E4    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_E4    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_E5    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_E5    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_E6    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_E6    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_E7    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_E7    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_E8    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x07
               ret
pulu6809_E8    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_E9    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_E9    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_EA    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_EA    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_EB    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_EB    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_EC    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_EC    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_ED    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_ED    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_EE    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_EE    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_EF    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pulu6809_EF    ENDP







;*************************************
;
;             0xF0
;
;*************************************


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_F0    PROC    near
               mov     bx,[R6809_USP]
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x08
               ret
pulu6809_F0    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_F1    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_F1    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_F2    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_F2    ENDP



;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_F3    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pulu6809_F3    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_F4    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_F4    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_F5    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pulu6809_F5    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_F6    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pulu6809_F6    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_F7    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0b
               ret
pulu6809_F7    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_F8    PROC    near
               mov     bx,[R6809_USP]
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x09
               ret
pulu6809_F8    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_F9    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pulu6809_F9    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_FA    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pulu6809_FA    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_FB    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0b
               ret
pulu6809_FB    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_FC    PROC    near
               mov     bx,[R6809_USP]
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0a
               ret
pulu6809_FC    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_FD    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0b
               ret
pulu6809_FD    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_FE    PROC    near
               mov     bx,[R6809_USP]
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0b
               ret
pulu6809_FE    ENDP


;
; CC,A,B,DP,X,Y,U,PC
;
pulu6809_FF    PROC    near
               mov     bx,[R6809_USP]
               mpull_cc
               mpull_a
               mpull_b
               mpull_dp
               mpull_x
               mpull_y
               mpull_s
               mpull_pc
               mov     [R6809_USP],bx
               mov     ax,0x0c
               ret
pulu6809_FF    ENDP







_PULU6809_TEXT ends






_PULU6809_DATA segment byte public 'DATA'
               assume  DS:_PULU6809_DATA

_Pulu6809JumpTable dd  pulu6809_00
                   dd  pulu6809_01
                   dd  pulu6809_02
                   dd  pulu6809_03
                   dd  pulu6809_04
                   dd  pulu6809_05
                   dd  pulu6809_06
                   dd  pulu6809_07
                   dd  pulu6809_08
                   dd  pulu6809_09
                   dd  pulu6809_0A
                   dd  pulu6809_0B
                   dd  pulu6809_0C
                   dd  pulu6809_0D
                   dd  pulu6809_0E
                   dd  pulu6809_0F
;10
                   dd  pulu6809_10
                   dd  pulu6809_11
                   dd  pulu6809_12
                   dd  pulu6809_13
                   dd  pulu6809_14
                   dd  pulu6809_15
                   dd  pulu6809_16
                   dd  pulu6809_17
                   dd  pulu6809_18
                   dd  pulu6809_19
                   dd  pulu6809_1A
                   dd  pulu6809_1B
                   dd  pulu6809_1C
                   dd  pulu6809_1D
                   dd  pulu6809_1E
                   dd  pulu6809_1F
;20
                   dd  pulu6809_20
                   dd  pulu6809_21
                   dd  pulu6809_22
                   dd  pulu6809_23
                   dd  pulu6809_24
                   dd  pulu6809_25
                   dd  pulu6809_26
                   dd  pulu6809_27
                   dd  pulu6809_28
                   dd  pulu6809_29
                   dd  pulu6809_2A
                   dd  pulu6809_2B
                   dd  pulu6809_2C
                   dd  pulu6809_2D
                   dd  pulu6809_2E
                   dd  pulu6809_2F
;30
                   dd  pulu6809_30
                   dd  pulu6809_31
                   dd  pulu6809_32
                   dd  pulu6809_33
                   dd  pulu6809_34
                   dd  pulu6809_35
                   dd  pulu6809_36
                   dd  pulu6809_37
                   dd  pulu6809_38
                   dd  pulu6809_39
                   dd  pulu6809_3A
                   dd  pulu6809_3B
                   dd  pulu6809_3C
                   dd  pulu6809_3D
                   dd  pulu6809_3E
                   dd  pulu6809_3F
;40
                   dd  pulu6809_40
                   dd  pulu6809_41
                   dd  pulu6809_42
                   dd  pulu6809_43
                   dd  pulu6809_44
                   dd  pulu6809_45
                   dd  pulu6809_46
                   dd  pulu6809_47
                   dd  pulu6809_48
                   dd  pulu6809_49
                   dd  pulu6809_4A
                   dd  pulu6809_4B
                   dd  pulu6809_4C
                   dd  pulu6809_4D
                   dd  pulu6809_4E
                   dd  pulu6809_4F
;50
                   dd  pulu6809_50
                   dd  pulu6809_51
                   dd  pulu6809_52
                   dd  pulu6809_53
                   dd  pulu6809_54
                   dd  pulu6809_55
                   dd  pulu6809_56
                   dd  pulu6809_57
                   dd  pulu6809_58
                   dd  pulu6809_59
                   dd  pulu6809_5A
                   dd  pulu6809_5B
                   dd  pulu6809_5C
                   dd  pulu6809_5D
                   dd  pulu6809_5E
                   dd  pulu6809_5F
;60
                   dd  pulu6809_60
                   dd  pulu6809_61
                   dd  pulu6809_62
                   dd  pulu6809_63
                   dd  pulu6809_64
                   dd  pulu6809_65
                   dd  pulu6809_66
                   dd  pulu6809_67
                   dd  pulu6809_68
                   dd  pulu6809_69
                   dd  pulu6809_6A
                   dd  pulu6809_6B
                   dd  pulu6809_6C
                   dd  pulu6809_6D
                   dd  pulu6809_6E
                   dd  pulu6809_6F
;70
                   dd  pulu6809_70
                   dd  pulu6809_71
                   dd  pulu6809_72
                   dd  pulu6809_73
                   dd  pulu6809_74
                   dd  pulu6809_75
                   dd  pulu6809_76
                   dd  pulu6809_77
                   dd  pulu6809_78
                   dd  pulu6809_79
                   dd  pulu6809_7A
                   dd  pulu6809_7B
                   dd  pulu6809_7C
                   dd  pulu6809_7D
                   dd  pulu6809_7E
                   dd  pulu6809_7F
;80
                   dd  pulu6809_80
                   dd  pulu6809_81
                   dd  pulu6809_82
                   dd  pulu6809_83
                   dd  pulu6809_84
                   dd  pulu6809_85
                   dd  pulu6809_86
                   dd  pulu6809_87
                   dd  pulu6809_88
                   dd  pulu6809_89
                   dd  pulu6809_8A
                   dd  pulu6809_8B
                   dd  pulu6809_8C
                   dd  pulu6809_8D
                   dd  pulu6809_8E
                   dd  pulu6809_8F
;90
                   dd  pulu6809_90
                   dd  pulu6809_91
                   dd  pulu6809_92
                   dd  pulu6809_93
                   dd  pulu6809_94
                   dd  pulu6809_95
                   dd  pulu6809_96
                   dd  pulu6809_97
                   dd  pulu6809_98
                   dd  pulu6809_99
                   dd  pulu6809_9A
                   dd  pulu6809_9B
                   dd  pulu6809_9C
                   dd  pulu6809_9D
                   dd  pulu6809_9E
                   dd  pulu6809_9F
;A0
                   dd  pulu6809_A0
                   dd  pulu6809_A1
                   dd  pulu6809_A2
                   dd  pulu6809_A3
                   dd  pulu6809_A4
                   dd  pulu6809_A5
                   dd  pulu6809_A6
                   dd  pulu6809_A7
                   dd  pulu6809_A8
                   dd  pulu6809_A9
                   dd  pulu6809_AA
                   dd  pulu6809_AB
                   dd  pulu6809_AC
                   dd  pulu6809_AD
                   dd  pulu6809_AE
                   dd  pulu6809_AF
;B0
                   dd  pulu6809_B0
                   dd  pulu6809_B1
                   dd  pulu6809_B2
                   dd  pulu6809_B3
                   dd  pulu6809_B4
                   dd  pulu6809_B5
                   dd  pulu6809_B6
                   dd  pulu6809_B7
                   dd  pulu6809_B8
                   dd  pulu6809_B9
                   dd  pulu6809_BA
                   dd  pulu6809_BB
                   dd  pulu6809_BC
                   dd  pulu6809_BD
                   dd  pulu6809_BE
                   dd  pulu6809_BF
;C0
                   dd  pulu6809_C0
                   dd  pulu6809_C1
                   dd  pulu6809_C2
                   dd  pulu6809_C3
                   dd  pulu6809_C4
                   dd  pulu6809_C5
                   dd  pulu6809_C6
                   dd  pulu6809_C7
                   dd  pulu6809_C8
                   dd  pulu6809_C9
                   dd  pulu6809_CA
                   dd  pulu6809_CB
                   dd  pulu6809_CC
                   dd  pulu6809_CD
                   dd  pulu6809_CE
                   dd  pulu6809_CF
;D0
                   dd  pulu6809_D0
                   dd  pulu6809_D1
                   dd  pulu6809_D2
                   dd  pulu6809_D3
                   dd  pulu6809_D4
                   dd  pulu6809_D5
                   dd  pulu6809_D6
                   dd  pulu6809_D7
                   dd  pulu6809_D8
                   dd  pulu6809_D9
                   dd  pulu6809_DA
                   dd  pulu6809_DB
                   dd  pulu6809_DC
                   dd  pulu6809_DD
                   dd  pulu6809_DE
                   dd  pulu6809_DF
;E0
                   dd  pulu6809_E0
                   dd  pulu6809_E1
                   dd  pulu6809_E2
                   dd  pulu6809_E3
                   dd  pulu6809_E4
                   dd  pulu6809_E5
                   dd  pulu6809_E6
                   dd  pulu6809_E7
                   dd  pulu6809_E8
                   dd  pulu6809_E9
                   dd  pulu6809_EA
                   dd  pulu6809_EB
                   dd  pulu6809_EC
                   dd  pulu6809_ED
                   dd  pulu6809_EE
                   dd  pulu6809_EF
;F0
                   dd  pulu6809_F0
                   dd  pulu6809_F1
                   dd  pulu6809_F2
                   dd  pulu6809_F3
                   dd  pulu6809_F4
                   dd  pulu6809_F5
                   dd  pulu6809_F6
                   dd  pulu6809_F7
                   dd  pulu6809_F8
                   dd  pulu6809_F9
                   dd  pulu6809_FA
                   dd  pulu6809_FB
                   dd  pulu6809_FC
                   dd  pulu6809_FD
                   dd  pulu6809_FE
                   dd  pulu6809_FF

public _Pulu6809JumpTable



_PULU6809_DATA ends



end

