;*****************************************************************************
;*                                                                           *
;*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Title      : 6809 Emulator assembler header file for common asm info    *
;*                                                                           *
;*   File Name  : REG6809.H                                                  *
;*                                                                           *
;*   Author     : Keith Wilkins                                              *
;*                                                                           *
;*   Version    : 1.00                                                       *
;*                                                                           *
;*   Desciption : This file contains the register definitions required by    *
;*                the assembly language functions                            *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   Revision History:                                                       *
;*                                                                           *
;*   Version    Date    Who  Description of changes                          *
;*   -------    ----    ---  ----------------------                          *
;*                                                                           *
;*    0.01    22/11/95  K.W  Creation of empty stub file, description only   *
;*    1.00    05/08/96  K.W  Public release of DVE V1.0                      *
;*                                                                           *
;*****************************************************************************


CPU_FETCH     equ 0x0000
CPU_WAIT      equ 0x00f7
CPU_HALT      equ 0x00f8
CPU_DECODE    equ 0x00f9
CPU_CWAI      equ 0x00fa
CPU_SYNC      equ 0x00fb
CPU_EXCEPTION equ 0x00fc


extern _tsCPURegisters:near

R6809_X       equ _tsCPURegisters
R6809_Y       equ _tsCPURegisters+0x0004
R6809_USP     equ _tsCPURegisters+0x0008
R6809_HSP     equ _tsCPURegisters+0x000c
R6809_PC      equ _tsCPURegisters+0x0010
R6809_D       equ _tsCPURegisters+0x0014
R6809_B       equ R6809_D
R6809_A       equ R6809_D+0x0001
R6809_DP      equ _tsCPURegisters+0x0018
R6809_8086CC  equ _tsCPURegisters+0x001c
R6809_CC      equ _tsCPURegisters+0x0020


