typedef struct save_all_struct
{
 // system ram and animaction extra ram
 T_CHAR sys_ram[0x800];
 T_CHAR plus_ram[0x800];

 // analog stuff
 T_SCHAR tIntegratorOffset;
 T_SCHAR lXSampleHold;
 T_SCHAR lYSampleHold;
 T_UCHAR tZSampleHold;

 T_SLONG lSIGDEF_XOUTPUT;
 T_SLONG lSIGDEF_YOUTPUT;
 T_UCHAR tSIGDEF_ZOUTPUT;

 // 6522 stuff
 T_UCHAR t6522ORB_0;
 T_UCHAR t6522IRB_0;
 T_UCHAR t6522IRB_0L;

 T_UCHAR t6522ORB_1;
 T_UCHAR t6522IRB_1;
 T_UCHAR t6522IRB_1L;

 T_UCHAR t6522ORB_2;
 T_UCHAR t6522IRB_2;
 T_UCHAR t6522IRB_2L;

 T_UCHAR t6522ORB_3;
 T_UCHAR t6522IRB_3;
 T_UCHAR t6522IRB_3L;

 T_UCHAR t6522ORB_4;
 T_UCHAR t6522IRB_4;
 T_UCHAR t6522IRB_4L;

 T_UCHAR t6522ORB_5;
 T_UCHAR t6522IRB_5;
 T_UCHAR t6522IRB_5L;

 T_UCHAR t6522ORB_6;
 T_UCHAR t6522IRB_6;
 T_UCHAR t6522IRB_6L;

 T_UCHAR t6522ORB_7REG;
 T_UCHAR t6522ORB_7;
 T_UCHAR t6522IRB_7;
 T_UCHAR t6522IRB_7L;

 T_UCHAR t6522ORA;
 T_UCHAR t6522IRA;
 T_UCHAR t6522IRAL;

 T_UCHAR t6522DDRB;
 T_UCHAR t6522DDRA;

 T_UCHAR t6522CA1;
 T_UCHAR t6522CA2;
 T_UCHAR t6522CB1;
 T_UCHAR t6522CB2;

 TIMER u6522Timer1;
 TIMER u6522Timer2;
 T_INT bTimer2OneShot;

 T_UCHAR t6522AUX_T1CTRL;
 T_UCHAR t6522AUX_T2CTRL;
 T_UCHAR t6522AUX_SHFTCTRL;
 T_UCHAR t6522AUX_PA_LE;
 T_UCHAR t6522AUX_PB_LE;

 T_UCHAR t6522PCR_CB2CTRL;
 T_UCHAR t6522PCR_CB1CTRL;
 T_UCHAR t6522PCR_CA2CTRL;
 T_UCHAR t6522PCR_CA1CTRL;

 T_UCHAR t6522IFLG;
 T_UCHAR t6522IER;

 T_UCHAR t6522SHFTREG;
 T_UCHAR t6522SHFTREGACT;

 // 6809 stuff
 T_LONG tcount;
 T_INT t1T_INT;
 T_INT iBPTriggered;
 T_SWORD iToggle;
 T_SWORD iCount;
 T_UWORD iInstruction;
 T_UWORD i6809status;
 T_UWORD iLastAddress;
 T_UWORD iBreakpoint;
 T_UWORD iBreakpointEnable;
 T_UWORD iSkipCount;
 CPUREGISTERS  tsCPURegisters;

 // sequencer stuff
 T_ULONG counter_since_change;
 T_INT wheel_color_rotator;

 T_INT state;
 T_INT frstate;
 T_SWORD tTicker;

 // sequencer stuff (from vectrex.h)
 T_UWORD ImagerColorNow;
 T_ULONG lwGblWheelTicks;
 T_SWORD wGblImagerXOffset1;
 T_SWORD wGblImagerXOffset2;
 T_SWORD wGblImagerXOffset;

 T_UWORD wGblColor1Degrees;
 T_UWORD wGblColor2Degrees;
 T_UWORD wGblColor3Degrees;
 T_SWORD tGblDebugLevel;
 T_SWORD tGblDebugMsgLevel;
 T_UWORD wGblPCJoystick; // 0 no (then keyboard) 1 = digital, 2 = analolg
 T_INT bGblExtendedRam;
 T_INT bGblStatsValid;
 T_ULONG lwGblSystemTickTotal;
 T_ULONG lwGblSystemTickBreakpoint;
 T_INT bGblDisplayAutoRefresh;
 T_INT bGblDisplayEnhance;
 T_INT bGblDisplayFullRefresh;
 T_INT bGblDisplayExactScaling;
 T_SLONG lwGblDisplayTickReload;
 T_ULONG lwGblDisplayTickMax;
 T_ULONG lwGblDisplayTickMin;
 T_SLONG lwGblDisplayTickCounter;
 T_UWORD wGblDisplayLinePeriod;
 T_UWORD wGblDisplayBaseColour;
 T_INT bGblOverlayEnable;
 T_INT bGblLightpenEnable; // read in *.vol file, default: false
 T_SLONG lwGblClipX;
 T_SLONG lwGblClipY;
 T_SLONG lwGblClipX_reset;
 T_SLONG lwGblClipY_reset;
 T_SLONG lwGblMaxTicks;
 ;T_UWORD wGblImagerMode;
 ;T_INT bGblGoggleGame;
 ;T_INT bGblForceSingleProcessor;
 ;T_INT bGblForceVesa12;
 ;T_INT bGblDebugEnable;
 ;T_INT bGblDebugFileEnable;
 ;T_INT bGblDebugMonitorEnable;
 ;T_INT bGblRestoreOnStart;
 ;T_INT bGblSaveOnExit;
 ;T_INT bGblNoShades;
 ;T_INT bGblLoadColorsExact;
 ;T_UWORD wGblQuitFlag;
 ;T_INT bGblDisplayEnable;
 ;T_INT bGblDisplayVerbose;
 ;T_UWORD wGblseal_audio_device;
 ;T_UWORD wGblSound;
 ;T_UWORD wGblDigitalVolume;
 ;T_INT bGblCartridgeROMWriteEnable;
 ;T_INT bGblSystemROMWriteEnable;
 ;T_UWORD wGblPly1Button1;
 ;T_UWORD wGblPly1Button2;
 ;T_UWORD wGblPly1Button3;
 ;T_UWORD wGblPly1Button4;
 ;T_UWORD wGblPly1JoystkUp;
 ;T_UWORD wGblPly1JoystkDn;
 ;T_UWORD wGblPly1JoystkLf;
 ;T_UWORD wGblPly1JoystkRt;

 ;T_UWORD wGblPly2Button1;
 ;T_UWORD wGblPly2Button2;
 ;T_UWORD wGblPly2Button3;
 ;T_UWORD wGblPly2Button4;

 ;T_UWORD wGblPly2JoystkUp;
 ;T_UWORD wGblPly2JoystkDn;
 ;T_UWORD wGblPly2JoystkLf;
 ;T_UWORD wGblPly2JoystkRt;

 ;T_INT bGblDigitalJoystick;
 ;T_SWORD wGblJoystickSensitivity;
 ;T_INT bGblJoystickAutoCentre;

 ;T_UWORD wGblDisplayMode;

 ;T_UCHAR acGblROMImageFileName[STRING_LENGTH];
 ;T_UCHAR acGblRAMImageFileName[STRING_LENGTH];
 ;T_UCHAR acGblDefaultCartFileName[STRING_LENGTH];

 ;T_UCHAR acGblCartCarousel[12][STRING_LENGTH];

 ;T_ULONG lwGblTicksToGrab;
 ;T_UWORD enable_event;
 ;T_INT reset_state;
 ;T_INT bGblGUIEnable;
 ;T_INT bGblPauseMode;
 ;UPDATE_FUNCTION *vectrex_update;

 ;T_UCHAR GblBinDir[STRING_LENGTH];
 ;T_UCHAR GblVolDir[STRING_LENGTH];
 ;T_UCHAR GblPicDir[STRING_LENGTH];
 ;T_UCHAR GblSvgDir[STRING_LENGTH];
 ;T_UCHAR GblDevDir[STRING_LENGTH];

 ;T_INT action_after_execution;
 ;T_INT init_after_execution;
 ;T_INT load_var;
 ;T_INT pause_on_monitor_entry_default;

 // sound stuff
 T_UCHAR tOLD_BC1;
 T_UCHAR tOLD_BDIR;
 T_UWORD tAddr;

 T_ULONG timer_tick;
 T_SLONG tick_timeout;
 T_ULONG last_timer_tick;
 T_ULONG new_ticks;
 T_WORD digisound;
 T_INT last_was_digi_sound;
 T_INT spike192;

 // display
 T_SWORD iLineSelected;
 T_SWORD iLineSelector;
 T_ULONG lwRefreshMarker;

 SDLINE line_store[LINESTORE_DEPTH];

 T_SWORD line_freelist;
 T_SWORD line_rootnode;

 T_SWORD hash_rootnodes[HASH_TABLE_SIZE];
 T_SWORD hash_freelist;
 SHASH hash_store[LINESTORE_DEPTH];
 T_SWORD diX1;
 T_SWORD diY1;
 T_SWORD diX2;
 T_SWORD diY2;
 T_SWORD hash_code;
 T_SWORD hash;
 T_SWORD line;
 T_INT display_init_back;
 T_INT fDNoPicload;

 // monitor stuff
 T_INT x;
 T_INT y;
 T_INT u;
 T_INT s;
 T_INT d;
 T_INT p;
 T_INT a;
 T_INT b;
 T_INT c;
 T_INT pg;

 T_SLONG lOldXSH;
 T_SLONG lOldYSH;
 T_UCHAR tOldZSH;

 T_SLONG lOldSigX;
 T_SLONG lOldSigY;
 T_UCHAR tOldSigZ;

 T_UCHAR tOldBlank;
 T_UCHAR tOldRamp;
 T_UCHAR tOldZero;
 T_UCHAR tOldSel;
 T_UCHAR tOldShold;
 T_UCHAR tOldDac;
 T_UCHAR tOldComp;
 T_SCHAR tOldIntegratorOffset;
 T_UCHAR tOldLastRamp;

 T_UCHAR toldORB_0;
 T_UCHAR toldIRB_0;
 T_UCHAR toldIRB_0L;
 T_UCHAR toldORB_1;
 T_UCHAR toldIRB_1;
 T_UCHAR toldIRB_1L;
 T_UCHAR toldORB_2;
 T_UCHAR toldIRB_2;
 T_UCHAR toldIRB_2L;
 T_UCHAR toldORB_3;
 T_UCHAR toldIRB_3;
 T_UCHAR toldIRB_3L;
 T_UCHAR toldORB_4;
 T_UCHAR toldIRB_4;
 T_UCHAR toldIRB_4L;
 T_UCHAR toldORB_5;
 T_UCHAR toldIRB_5;
 T_UCHAR toldIRB_5L;
 T_UCHAR toldORB_6;
 T_UCHAR toldIRB_6;
 T_UCHAR toldIRB_6L;
 T_UCHAR toldORB_7;
 T_UCHAR toldIRB_7;
 T_UCHAR toldIRB_7L;
 T_UCHAR toldORA;
 T_UCHAR toldIRA;
 T_UCHAR toldIRAL;
 T_UCHAR toldDDRA;
 T_UCHAR toldDDRB;
 T_UCHAR toldSHFTREG;
 T_UCHAR toldAUX_T1CTRL;
 T_UCHAR toldAUX_T2CTRL;
 T_UCHAR toldAUX_SHFTCTRL;
 T_UCHAR toldAUX_PA_LE;
 T_UCHAR toldAUX_PB_LE;
 T_UCHAR toldPCR_CB1CTRL;
 T_UCHAR toldPCR_CB2CTRL;
 T_UCHAR toldPCR_CA1CTRL;
 T_UCHAR toldPCR_CA2CTRL;
 T_UCHAR toldIER;
 T_UCHAR toldIFLG;
 T_UCHAR toldCA1;
 T_UCHAR toldCA2;
 T_UCHAR toldCB1;
 T_UCHAR toldCB2;
 T_UWORD uoldTimer1uLatchtW;
 T_UWORD uoldTimer1uCounttW;
 T_UWORD uoldTimer2uLatchtW;
 T_UWORD uoldTimer2uCounttW;
 T_UCHAR _old0;
 T_UCHAR _old1;
 T_UCHAR _old2;
 T_UCHAR _old3;
 T_UCHAR _old4;
 T_UCHAR _old5;
 T_UCHAR _old6;
 T_UCHAR _old7;
 T_UCHAR _old8;
 T_UCHAR _old9;
 T_UCHAR _old10;
 T_UCHAR _old11;
 T_UCHAR _old12;
 T_UCHAR _old13;
 T_UCHAR _old14;
 T_UCHAR _old15;

// debug stuff
 T_ULONG steps;
 T_CHAR string_buffer[EDIT_LINE_LEN+1];
 T_INT old_pause_state;
 T_INT bStepRun;
 T_INT bStep;

// analog / joystick
 T_SCHAR joy1x;
 T_SCHAR joy2x;
 T_SCHAR joy1y;
 T_SCHAR joy2y;

 T_INT button1a;
 T_INT button1b;
 T_INT button2a;
 T_INT button2b;

}SAVE_ALL;
