#ifdef _NO_DEBUG_INFORMATION_

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <tools.h>
#include <standard.h>

#include "io.h"
#include "keyboard.h"
#include "sound.h"
#include "emu6809.h"
#include "emu6522.h"
#include "analog.h"
#include "display.h"
#include "verror.h"
#include "vdebug.h"
#include "dis6809.h"
#include "monitor.h"
#include "vectrex.h"
#include "sequence.h"

// from vesa_c
extern volatile T_INT vesa_mouse_changed;

#endif //#ifdef _NO_DEBUG_INFORMATION_


#ifndef _NO_DEBUG_INFORMATION_

/*****************************************************************************/
/*                                                                           */
/*   Function    : fVectrexEmulate()                                         */
/*                                                                           */
/*   Author      : K.W                                                       */
/*                                                                           */
/*   Description : This function is the HEART of the emluator. It schedules  */
/*                 and executes all of the functions that make up the        */
/*                 Vectrex emulator. The system is run on an infinite loop   */
/*                 which is only broken if the tQuitFlag==TRUE, this is a    */
/*                 global variable and can be set by any module of the user  */
/*                 wants to quit or the error is serious enough. For each    */
/*                 loop the gGblSystemTick variable is incremented. Also     */
/*                 for each loop the tGbl????SystemTickCounters are decreme- */
/*                 nted and when one reaches zero tGbl????SystemTickTotal    */
/*                 is incremented and the f????Tick function is executed.    */
/*                                                                           */
/*                 The debug flags can disable the execution of any of the   */
/*                 tick functions in an individual basis. When the DEBUG     */
/*                 mode is activated the fDoDebug() is called on every       */
/*                 time tGblSystemTick in incrmented.                        */
/*                                                                           */
/*   Accepts     : nothing                                                   */
/*                                                                           */
/*   Returns     : TRUE or FALSE depending on if an error occured            */
/*                                                                           */
/*****************************************************************************/

/* different sequencers for different needs... */

#define SEQUENCER_LIGHTPEN
T_VOID fVectrexEmulate_banked_lightpen(T_VOID)
#ifdef TRYING
{return;}
#endif
#ifndef TRYING
#define SEQUENCER_BANKED
#include "seq.cc"
#undef SEQUENCER_BANKED
#undef SEQUENCER_LIGHTPEN
#endif

#endif //#ifndef _NO_DEBUG_INFORMATION_
