/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : Vectrex emulator sequencing module header file             */
/*                                                                           */
/*   File Name  : SEQUENCE.H                                                 */
/*                                                                           */
/*   Author     : Keith Wilkins / C.S.                                       */
/*                                                                           */
/*   Version    : 1.20                                                       */
/*                                                                           */
/*   Desciption : This file contains the functions definitions & prototypes  */
/*                for the sequencer module.                                  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    14/03/93  K.W  Creation of empty file and descriptions         */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*    1.00    20/10/96  C.S  DVE V1.20                                       */
/*                                                                           */
/*****************************************************************************/

#if !defined SEQUENCE_H
#define SEQUENCE_H

#include <standard.h>

extern T_VOID (* fVectrexEmulate)(T_VOID);

extern T_VOID (* fSequencerReset)(T_UWORD);        // Trigger sequencer reset
extern T_VOID (* fSequencerReboot)(T_UWORD);       // System reset
extern T_VOID (* fCarouselSelect)(T_UWORD);        // Select from a number of games
extern T_VOID (* fSaveState)(T_UWORD);
extern T_VOID (* fLoadState)(T_UWORD);
extern T_VOID (* fEnableEvent)(T_UWORD);
extern T_VOID (* fGUIToggle)(T_UWORD);

extern T_VOID (* fDebugMonitorToggle)(T_UWORD);
extern T_VOID (* fDebugToggle)(T_UWORD);
extern T_VOID (* fDebugFileToggle)(T_UWORD);
extern T_VOID (* fDebugLevelLow)(T_UWORD);
extern T_VOID (* fDebugLevelMid)(T_UWORD);
extern T_VOID (* fDebugLevelHigh)(T_UWORD);

T_VOID fopen_monitor_debug_pause(T_VOID);
T_VOID firstrun(T_VOID);
T_VOID fSequencerPause(T_UWORD);
T_VOID fSequencerAbort(T_UWORD);        // Trigger sequencer abort
T_VOID fScreenshot(T_UWORD);
T_VOID set_seq0_functions(T_INT type);

extern T_ULONG counter_since_change;
extern T_INT wheel_color_rotator;

#ifdef CLAY_ONLY
extern T_INT cscreenshots;
extern T_INT cgrabsdone;
#endif
extern T_INT state;
extern T_INT frstate;
extern T_SWORD tTicker;

#endif
