/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : AY-3-8192 Sound Chip emulation module header file          */
/*                                                                           */
/*   File Name  : SOUNDEMU.H                                                 */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file contains the function prototypes and definitions */
/*                for the AY-3-8192 sound chip emulation module.             */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    14/03/93  K.W  Creation of empty file and descriptions         */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

#if !defined SOUND_C
    #define SOUND_C

#include <stdlib.h>

#include <standard.h>
#include "nonesnd.h"
#include "sound.h"

T_BOOL (* fSoundInit)(T_VOID)=NULL;
T_VOID (* fSoundReset)(T_VOID)=NULL;
T_VOID (* fSoundRestore)(T_VOID)=NULL;
T_VOID (* fSoundTick)(T_VOID)=NULL;
T_VOID (* fSoundMute)(T_VOID)=NULL;
T_VOID (* fSoundResume)(T_VOID)=NULL;

T_VOID (* InitTimerHandler)(T_VOID)=NULL;
T_VOID (* DoneTimerHandler)(T_VOID)=NULL;

T_INT last_was_digi_sound=T_FALSE;
T_WORD digisound=T_FALSE;
T_UCHAR tKeyWord=0;
T_UCHAR tKeyOut=0;
//T_INT spike192=T_FALSE;


T_UCHAR tOLD_BC1=0;
T_UCHAR tOLD_BDIR=0;
T_UWORD tAddr=0;


volatile T_ULONG timer_tick=0;
T_SLONG tick_timeout=1;
T_ULONG last_timer_tick=0;
T_ULONG new_ticks=0;

// this is just a quick hack :-) (as you will see)
T_UINT imager_values[1000]=
{
//0-100
10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2,
10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2,
10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2,
10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2,
10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2,
10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2,
10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2,
10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2,
10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2,
10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2, 10000/2,

//0-200
20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2,
20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2,
20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2,
20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2,
20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2,
20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2,
20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2,
20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2,
20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2,
20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2, 20000/2,

//0-300
30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2,
30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2,
30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2,
30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2,
30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2,
30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2,
30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2,
30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2,
30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2,
30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2, 30000/2,

//0-400
40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2,
40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2,
40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2,
40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2,
40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2,
40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2,
40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2,
40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2,
40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2,
40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2, 40000/2,

//0-500
50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2,
50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2,
50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2,
50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2,
50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2,
50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2,
50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2,
50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2,
50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2,
50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2, 50000/2,
//0-600

60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2,
60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2,
60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2,
60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2,
60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2,
60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2,
60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2,
60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2,
60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2, 60000/2,
57344/2, 57344/2, 57344/2, 57344/2, 57344/2, 57344/2, 57344/2, 57344/2, 57344/2, 57344/2,  // narrow escape

//0-700
//61440/2, 61440/2, 61440/2, 61440/2, 61440/2, 61440/2, 61440/2, 61440/2, 61440/2, 61440/2,  // crazy coaster
47900/2, 47900/2, 47900/2, 47900/2, 47900/2, 47900/2, 47900/2, 47900/2, 47900/2, 47900/2,  // crazy coaster
70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2,
70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2,
65024/2, 65024/2, 65024/2, 65024/2, 65024/2, 65024/2, 65024/2, 65024/2, 65024/2, 65024/2,  // mine 3d
70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2,
70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2,
70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2,
70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2,
70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2,
70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2, 70000/2,

//0-800
80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2,
80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2,
80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2,
80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2,
80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2,
80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2,
80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2,
80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2,
80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2,
80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2, 80000/2,

//0-900
90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2,
90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2,
90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2,
90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2,
90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2,
90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2,
90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2,
90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2,
90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2,
90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2, 90000/2,

//0-1000
99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2,
99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2,
99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2,
99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2,
99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2,
99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2,
99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2,
99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2,
99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2,
99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2, 99999/2

};

/*****************************/
/* DOS Timer vector handlers */
/*****************************/
T_VOID __far __interrupt *dos_timer_handler;


#endif

/* End of SOUND_C */
