/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : AY-3-8192 Sound Chip emulation module header file          */
/*                                                                           */
/*   File Name  : SOUND.H                                                    */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file contains the function prototypes and definitions */
/*                for the AY-3-8192 sound chip emulation module.             */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    14/03/93  K.W  Creation of empty file and descriptions         */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

#if !defined SOUND_H
    #define SOUND_H

#define SOUND_NONE  0
#define SOUND_ADLIB 1
#define SOUND_SEAL  2

/*****************************/
/* DOS Timer vector handlers */
/*****************************/

// timer updates per second
#define DOS_TIMER_IRQ  0x1c
#define UPDATES_PER_SEC (50) /*(50)*/
#define TIMER_RATE (1193180/UPDATES_PER_SEC)
#define KBD_WAIT (UPDATES_PER_SEC/12)

#include <standard.h>

extern T_INT  (* fSoundInit)(T_VOID);
extern T_VOID (* fSoundReset)(T_VOID);
extern T_VOID (* fSoundRestore)(T_VOID);
extern T_VOID (* fSoundTick)(T_VOID);
extern T_VOID (* fSoundMute)(T_VOID);
extern T_VOID (* fSoundResume)(T_VOID);

extern T_UCHAR tOLD_BC1;
extern T_UCHAR tOLD_BDIR;
extern T_UWORD tAddr;

extern volatile T_ULONG timer_tick;
extern T_SLONG tick_timeout;
extern T_ULONG last_timer_tick;
extern T_ULONG new_ticks;
extern T_WORD digisound;
extern T_INT last_was_digi_sound;
extern T_UCHAR tKeyWord;
extern T_UCHAR tKeyOut;
extern T_UINT imager_values[1000];

//extern T_INT spike192;

extern T_VOID __far __interrupt *dos_timer_handler;
extern T_VOID (* InitTimerHandler)(T_VOID);
extern T_VOID (* DoneTimerHandler)(T_VOID);

#endif

/* End of SOUND.H */
