/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : Vectrex System RAM Emulation header file                   */
/*                                                                           */
/*   File Name  : SYS_RAM.H                                                  */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file contains the functions prototypes and definition */
/*                for the system RAM emulation functions.                    */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    14/03/93  K.W  Creation of empty file and descriptions         */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

#if !defined SYS_RAM_H
    #define SYS_RAM_H

/* Define some base definitions */

#define SYSTEM_RAM_SIZE         0x0400

#define SYSTEM_RAM_ADDRESS_MASK 0x03FF

#define SYSTEM_RAM_BASE         0xC800
#define SYSTEM_RAM_TOP          (SYSTEM_RAM_BASE+SYSTEM_RAM_SIZE-1)

#define SYSTEM_RAM_FILL_VALUE   0xFF

/* Define function prototypes */

extern T_INT      (* fSystemRAMLoad)(T_PUCHAR);
extern T_INT      (* fSystemRAMSave)(T_PUCHAR);
extern T_UCHAR    (* fSystemRAMRead)(T_UWORD);
extern T_UCHAR    (* fSystemRAMWrite)(T_UWORD, T_UCHAR);

T_VOID set_sys_ram_functions(T_INT type);

#endif
