/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : Vectrex System ROM Emulation header file                   */
/*                                                                           */
/*   File Name  : SYS_ROM.H                                                  */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file contains the functions prototypes and definition */
/*                for the system ROM emulation functions.                    */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    14/03/93  K.W  Creation of empty file and descriptions         */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

#if !defined SYS_ROM_H
    #define SYS_ROM_H

/* Define some base definitions */

#define SYSTEM_ROM_SIZE         0x2000

#define SYSTEM_ROM_ADDRESS_MASK 0x1FFF

#define SYSTEM_ROM_BASE         0xE000
#define SYSTEM_ROM_TOP          0xFFFF

#define SYSTEM_ROM_FILL_VALUE   0xFF

/* Define function prototypes */

extern T_INT      (* fSystemROMLoad)(T_PUCHAR);
extern T_INT      (* fSystemROMSave)(T_PUCHAR);
extern T_UCHAR    (* fSystemROMRead)(T_UWORD);
extern T_UCHAR    (* fSystemROMWrite)(T_UWORD, T_UCHAR);

T_VOID set_sys_rom_functions(T_INT type);

#endif
