/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : 6809 Dissasembler Mnemonic definitions                     */
/*                                                                           */
/*   File Name  : CODE6809.H                                                 */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file defines the array holding definitions for diss-  */
/*                assembling 6809 code.                                      */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    28/03/93  K.W  Creation                                        */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/


#ifndef CODE6809_H
 #define CODE6809_H

#include <standard.h>

#include "dis6809.h"

/* Declare arrays of register names for disassembler */

T_UCHAR asRegNames1[16][4]=
{
 "D"  ,"X"  ,"Y"  ,"U"  ,"S"  ,"PC" ,"??" ,"??",
 "A"  ,"B"  ,"CCR","DPR","??" ,"??" ,"??" ,"??"
};

T_UCHAR asRegNames2[8][4]=
{
 "CCR","A","B","DPR","X","Y","S/U","PC"
};

/* Define data table to decode indexed opcodes */

typedef struct sIndexElement
{
 T_UWORD   wWordSize;
 T_UCHAR   acFormat[12];
} tsIndexElement;


T_UCHAR ac6809Modes[13][20]=
{
 "ILLEGAL","PAGE2","PAGE3","DIRECT","EXTENDED",
 "INHERENT","RELATIVE8","RELATIVE16","IMMEDIATE8",
 "IMMEDIATE16","INDEXED","REGISTER1","REGISTER2"
};

tsIndexElement asIndexDecode[256]=
{
        /* 0x0000 */    0,"$00,X",
                                        0,"$01,X",
                                        0,"$02,X",
                                        0,"$03,X",
                                        0,"$04,X",
                                        0,"$05,X",
                                        0,"$06,X",
                                        0,"$07,X",
        /* 0x0008 */    0,"$08,X",
                                        0,"$09,X",
                                        0,"$0a,X",
                                        0,"$0b,X",
                                        0,"$0c,X",
                                        0,"$0d,X",
                                        0,"$0e,X",
                                        0,"$0f,X",
        /* 0x0010 */    0,"-$10,X",
                                        0,"-$0f,X",
                                        0,"-$0e,X",
                                        0,"-$0d,X",
                                        0,"-$0c,X",
                                        0,"-$0b,X",
                                        0,"-$0a,X",
                                        0,"-$09,X",
        /* 0x0018 */    0,"-$08,X",
                                        0,"-$07,X",
                                        0,"-$06,X",
                                        0,"-$05,X",
                                        0,"-$04,X",
                                        0,"-$03,X",
                                        0,"-$02,X",
                                        0,"-$01,X",
        /* 0x0020 */    0,"$00,Y",
                                        0,"$01,Y",
                                        0,"$02,Y",
                                        0,"$03,Y",
                                        0,"$04,Y",
                                        0,"$05,Y",
                                        0,"$06,Y",
                                        0,"$07,Y",
        /* 0x0028 */    0,"$08,Y",
                                        0,"$09,Y",
                                        0,"$0a,Y",
                                        0,"$0b,Y",
                                        0,"$0c,Y",
                                        0,"$0d,Y",
                                        0,"$0e,Y",
                                        0,"$0f,Y",
        /* 0x0030 */    0,"-$10,Y",
                                        0,"-$0f,Y",
                                        0,"-$0e,Y",
                                        0,"-$0d,Y",
                                        0,"-$0c,Y",
                                        0,"-$0b,Y",
                                        0,"-$0a,Y",
                                        0,"-$09,Y",
        /* 0x0038 */    0,"-$08,Y",
                                        0,"-$07,Y",
                                        0,"-$06,Y",
                                        0,"-$05,Y",
                                        0,"-$04,Y",
                                        0,"-$03,Y",
                                        0,"-$02,Y",
                                        0,"-$01,Y",
        /* 0x0040 */    0,"$00,U",
                                        0,"$01,U",
                                        0,"$02,U",
                                        0,"$03,U",
                                        0,"$04,U",
                                        0,"$05,U",
                                        0,"$06,U",
                                        0,"$07,U",
        /* 0x0048 */    0,"$08,U",
                                        0,"$09,U",
                                        0,"$0a,U",
                                        0,"$0b,U",
                                        0,"$0c,U",
                                        0,"$0d,U",
                                        0,"$0e,U",
                                        0,"$0f,U",
        /* 0x0050 */    0,"-$10,U",
                                        0,"-$0f,U",
                                        0,"-$0e,U",
                                        0,"-$0d,U",
                                        0,"-$0c,U",
                                        0,"-$0b,U",
                                        0,"-$0a,U",
                                        0,"-$09,U",
        /* 0x0058 */    0,"-$08,U",
                                        0,"-$07,U",
                                        0,"-$06,U",
                                        0,"-$05,U",
                                        0,"-$04,U",
                                        0,"-$03,U",
                                        0,"-$02,U",
                                        0,"-$01,U",
        /* 0x0060 */    0,"$00,S",
                                        0,"$01,S",
                                        0,"$02,S",
                                        0,"$03,S",
                                        0,"$04,S",
                                        0,"$05,S",
                                        0,"$06,S",
                                        0,"$07,S",
        /* 0x0068 */    0,"$08,S",
                                        0,"$09,S",
                                        0,"$0a,S",
                                        0,"$0b,S",
                                        0,"$0c,S",
                                        0,"$0d,S",
                                        0,"$0e,S",
                                        0,"$0f,S",
        /* 0x0070 */    0,"-$10,S",
                                        0,"-$0f,S",
                                        0,"-$0e,S",
                                        0,"-$0d,S",
                                        0,"-$0c,S",
                                        0,"-$0b,S",
                                        0,"-$0a,S",
                                        0,"-$09,S",
        /* 0x0078 */    0,"-$08,S",
                                        0,"-$07,S",
                                        0,"-$06,S",
                                        0,"-$05,S",
                                        0,"-$04,S",
                                        0,"-$03,S",
                                        0,"-$02,S",
                                        0,"-$01,S",

        /* 10000000 */  0,",X+",
        /* 10000001 */  0,",X++",
        /* 10000010 */  0,",-X",
        /* 10000011 */  0,",--X",
        /* 10000100 */  0,",X",
        /* 10000101 */  0,"B,X",
        /* 10000110 */  0,"A,X",
        /* 10000111 */  0,"Illegal",
        /* 10001000 */  1,"$%02x,X",
        /* 10001001 */  2,"$%04x,X",
        /* 10001010 */  0,"Illegal",
        /* 10001011 */  0,"D,X",
        /* 10001100 */  1,"$%02x,PCR",
        /* 10001101 */  2,"$%04x,PCR",
        /* 10001110 */  0,"Illegal",
        /* 10001111 */  0,"Illegal",
        /* 10010000 */  0,"Illegal",
        /* 10010001 */  0,"[,X++]",
        /* 10010010 */  0,"Illegal",
        /* 10010011 */  0,"[,--X]",
        /* 10010100 */  0,"[,X]",
        /* 10010101 */  0,"[B,X]",
        /* 10010110 */  0,"[A,X]",
        /* 10010111 */  0,"Illegal",
        /* 10011000 */  1,"[$%02x,X]",
        /* 10011001 */  2,"[$%04x,X]",
        /* 10011010 */  0,"Illegal",
        /* 10011011 */  0,"[D,X]",
        /* 10011100 */  1,"[$%02x,PCR]",
        /* 10011101 */  2,"[$%04x,PCR]",
        /* 10011110 */  0,"Illegal",
        /* 10011111 */  2,"[$%04x]",

        /* 10100000 */  0,",Y+",
        /* 10100001 */  0,",Y++",
        /* 10100010 */  0,",-Y",
        /* 10100011 */  0,",--Y",
        /* 10100100 */  0,",Y",
        /* 10100101 */  0,"B,Y",
        /* 10100110 */  0,"A,Y",
        /* 10100111 */  0,"Illegal",
        /* 10101000 */  1,"$%02x,Y",
        /* 10101001 */  2,"$%04x,Y",
        /* 10101010 */  0,"Illegal",
        /* 10101011 */  0,"D,Y",
        /* 10101100 */  1,"$%02x,PCR",
        /* 10101101 */  2,"$%04x,PCR",
        /* 10101110 */  0,"Illegal",
        /* 10101111 */  0,"Illegal",
        /* 10110000 */  0,"Illegal",
        /* 10110001 */  0,"[,Y++]",
        /* 10110010 */  0,"Illegal",
        /* 10110011 */  0,"[,--Y]",
        /* 10110100 */  0,"[,Y]",
        /* 10110101 */  0,"[B,Y]",
        /* 10110110 */  0,"[A,Y]",
        /* 10110111 */  0,"Illegal",
        /* 10111000 */  1,"[$%02x,Y]",
        /* 10111001 */  2,"[$%04x,Y]",
        /* 10111010 */  0,"Illegal",
        /* 10111011 */  0,"[D,Y]",
        /* 10111100 */  1,"[$%02x,PCR]",
        /* 10111101 */  2,"[$%04x,PCR]",
        /* 10111110 */  0,"Illegal",
        /* 10111111 */  0,"Illegal",

        /* 11000000 */  0,",U+",
        /* 11000001 */  0,",U++",
        /* 11000010 */  0,",-U",
        /* 11000011 */  0,",--U",
        /* 11000100 */  0,",U",
        /* 11000101 */  0,"B,U",
        /* 11000110 */  0,"A,U",
        /* 11000111 */  0,"Illegal",
        /* 11001000 */  1,"$%02x,U",
        /* 11001001 */  2,"$%04x,U",
        /* 11001010 */  0,"Illegal",
        /* 11001011 */  0,"D,U",
        /* 11001100 */  1,"$%02x,PCR",
        /* 11001101 */  2,"$%04x,PCR",
        /* 11001110 */  0,"Illegal",
        /* 11001111 */  0,"Illegal",
        /* 11010000 */  0,"Illegal",
        /* 11010001 */  0,"[,U++]",
        /* 11010010 */  0,"Illegal",
        /* 11010011 */  0,"[,--U]",
        /* 11010100 */  0,"[,U]",
        /* 11010101 */  0,"[B,U]",
        /* 11010110 */  0,"[A,U]",
        /* 11010111 */  0,"Illegal",
        /* 11011000 */  1,"[$%02x,U]",
        /* 11011001 */  2,"[$%04x,U]",
        /* 11011010 */  0,"Illegal",
        /* 11011011 */  0,"[D,U]",
        /* 11011100 */  1,"[$%02x,PCR]",
        /* 11011101 */  2,"[$%04x,PCR]",
        /* 11011110 */  0,"Illegal",
        /* 11011111 */  0,"Illegal",

        /* 11100000 */  0,",S+",
        /* 11100001 */  0,",S++",
        /* 11100010 */  0,",-S",
        /* 11100011 */  0,",--S",
        /* 11100100 */  0,",S",
        /* 11100101 */  0,"B,S",
        /* 11100110 */  0,"A,S",
        /* 11100111 */  0,"Illegal",
        /* 11101000 */  1,"$%02x,S",
        /* 11101001 */  2,"$%04x,S",
        /* 11101010 */  0,"Illegal",
        /* 11101011 */  0,"D,S",
        /* 11101100 */  1,"$%02x,PCR",
        /* 11101101 */  2,"$%04x,PCR",
        /* 11101110 */  0,"Illegal",
        /* 11101111 */  0,"Illegal",
        /* 11110000 */  0,"Illegal",
        /* 11110001 */  0,"[,S++]",
        /* 11110010 */  0,"Illegal",
        /* 11110011 */  0,"[,--S]",
        /* 11110100 */  0,"[,S]",
        /* 11110101 */  0,"[B,S]",
        /* 11110110 */  0,"[A,S]",
        /* 11110111 */  0,"Illegal",
        /* 11111000 */  1,"[$%02x,S]",
        /* 11111001 */  2,"[$%04x,S]",
        /* 11111010 */  0,"Illegal",
        /* 11111011 */  0,"[D,S]",
        /* 11111100 */  1,"[$%02x,PCR]",
        /* 11111101 */  2,"[$%04x,PCR]",
        /* 11111110 */  0,"Illegal",
        /* 11111111 */  0,"Illegal",

};


tsMNEMONIC   as6809Dis[NO_OF_6809_OPCODES]=
{
/*  Mnem        Name                Mode */

/* 0x0000 */    "NEG "  ,DIRECT,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "COM "  ,DIRECT,
                "LSR "  ,DIRECT,
                ""      ,ILLEGAL,
                "ROR "  ,DIRECT,
                "ASR "  ,DIRECT,
/* 0x0008 */    "ASL "  ,DIRECT,
                "ROL "  ,DIRECT,
                "DEC "  ,DIRECT,
                ""      ,ILLEGAL,
                "INC "  ,DIRECT,
                "TST "  ,DIRECT,
                "JMP "  ,DIRECT,
                "CLR "  ,DIRECT,
/* 0x0010 */    "Pag2"  ,PAGE2,
                "Pag3"  ,PAGE3,
                "NOP "  ,INHERENT,
                "SYNC"  ,INHERENT,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "LBRA"  ,RELATIVE16,
                "LBSR"  ,RELATIVE16,
/* 0x0018 */    ""      ,ILLEGAL,
                "DAA "  ,INHERENT,
                "ORCC"  ,IMMEDIATE8,
                ""      ,ILLEGAL,
                "ANDC"  ,IMMEDIATE8,       /* Was "ANDCC" */
                "SEX "  ,INHERENT,
                "EXG "  ,REGISTER1,
                "TFR "  ,REGISTER1,
/* 0x0020 */    "BRA "  ,RELATIVE8,
                "BRN "  ,RELATIVE8,
                "BHI "  ,RELATIVE8,
                "BLS "  ,RELATIVE8,
                "BHS "  ,RELATIVE8,
                "BLO "  ,RELATIVE8,
                "BNE "  ,RELATIVE8,
                "BEQ "  ,RELATIVE8,
/* 0x0028 */    "BVC "  ,RELATIVE8,
                "BVS "  ,RELATIVE8,
                "BPL "  ,RELATIVE8,
                "BMI "  ,RELATIVE8,
                "BGE "  ,RELATIVE8,
                "BLT "  ,RELATIVE8,
                "BGT "  ,RELATIVE8,
                "BLE "  ,RELATIVE8,
/* 0x0030 */    "LEAX"  ,INDEXED,
                "LEAY"  ,INDEXED,
                "LEAS"  ,INDEXED,
                "LEAU"  ,INDEXED,
                "PSHS"  ,REGISTER2,
                "PULS"  ,REGISTER2,
                "PSHU"  ,REGISTER2,
                "PULU"  ,REGISTER2,
/* 0x0038 */    ""      ,ILLEGAL,
                "RTS "  ,INHERENT,
                "ABX "  ,INHERENT,
                "RTI "  ,INHERENT,
                "CWAI"  ,IMMEDIATE8,
                "MUL "  ,INHERENT,
                ""      ,ILLEGAL,
                "SWI "  ,INHERENT,
/* 0x0040 */    "NEGA"  ,INHERENT,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "COMA"  ,INHERENT,
                "LSRA"  ,INHERENT,
                ""      ,ILLEGAL,
                "RORA"  ,INHERENT,
                "ASRA"  ,INHERENT,
/* 0x0048 */    "ASLA"  ,INHERENT,
                "ROLA"  ,INHERENT,
                "DECA"  ,INHERENT,
                ""      ,ILLEGAL,
                "INCA"  ,INHERENT,
                "TSTA"  ,INHERENT,
                ""      ,ILLEGAL,
                "CLRA"  ,INHERENT,
/* 0x0050 */    "NEGB"  ,INHERENT,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "COMB"  ,INHERENT,
                "LSRB"  ,INHERENT,
                ""      ,ILLEGAL,
                "RORB"  ,INHERENT,
                "ASRB"  ,INHERENT,
/* 0x0058 */    "ASLB"  ,INHERENT,
                "ROLB"  ,INHERENT,
                "DECB"  ,INHERENT,
                ""      ,ILLEGAL,
                "INCB"  ,INHERENT,
                "TSTB"  ,INHERENT,
                ""      ,ILLEGAL,
                "CLRB"  ,INHERENT,
/* 0x0060 */    "NEG "  ,INDEXED,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "COM "  ,INDEXED,
                "LSR "  ,INDEXED,
                ""      ,ILLEGAL,
                "ROR "  ,INDEXED,
                "ASR "  ,INDEXED,
/* 0x0068 */    "ASL "  ,INDEXED,
                "ROL "  ,INDEXED,
                "DEC "  ,INDEXED,
                ""      ,ILLEGAL,
                "INC "  ,INDEXED,
                "TST "  ,INDEXED,
                "JMP "  ,INDEXED,
                "CLR "  ,INDEXED,
/* 0x0070 */    "NEG "  ,EXTENDED,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "COM "  ,EXTENDED,
                "LSR "  ,EXTENDED,
                ""      ,ILLEGAL,
                "ROR "  ,EXTENDED,
                "ASR "  ,EXTENDED,
/* 0x0078 */    "ASL "  ,EXTENDED,
                "ROL "  ,EXTENDED,
                "DEC "  ,EXTENDED,
                ""      ,ILLEGAL,
                "INC "  ,EXTENDED,
                "TST "  ,EXTENDED,
                "JMP "  ,EXTENDED,
                "CLR "  ,EXTENDED,
/* 0x0080 */    "SUBA"  ,IMMEDIATE8,
                "CMPA"  ,IMMEDIATE8,
                "SBCA"  ,IMMEDIATE8,
                "SUBD"  ,IMMEDIATE16,
                "ANDA"  ,IMMEDIATE8,
                "BITA"  ,IMMEDIATE8,
                "LDA "  ,IMMEDIATE8,
                ""      ,ILLEGAL,
/* 0x0088 */    "EORA"  ,IMMEDIATE8,
                "ADCA"  ,IMMEDIATE8,
                "ORA "  ,IMMEDIATE8,
                "ADDA"  ,IMMEDIATE8,
                "CMPX"  ,IMMEDIATE16,
                "BSR "  ,RELATIVE8,
                "LDX "  ,IMMEDIATE16,
                ""      ,ILLEGAL,
/* 0x0090 */    "SUBA"  ,DIRECT,
                "CMPA"  ,DIRECT,
                "SBCA"  ,DIRECT,
                "SUBD"  ,DIRECT,
                "ANDA"  ,DIRECT,
                "BITA"  ,DIRECT,
                "LDA "  ,DIRECT,
                "STA "  ,DIRECT,
/* 0x0098 */    "EORA"  ,DIRECT,
                "ADCA"  ,DIRECT,
                "ORA "  ,DIRECT,
                "ADDA"  ,DIRECT,
                "CMPX"  ,DIRECT,
                "JSR "  ,DIRECT,
                "LDX "  ,DIRECT,
                "STX "  ,DIRECT,
/* 0x00A0 */    "SUBA"  ,INDEXED,
                "CMPA"  ,INDEXED,
                "SBCA"  ,INDEXED,
                "SUBD"  ,INDEXED,
                "ANDA"  ,INDEXED,
                "BITA"  ,INDEXED,
                "LDA "  ,INDEXED,
                "STA "  ,INDEXED,
/* 0x00A8 */    "EORA"  ,INDEXED,
                "ADCA"  ,INDEXED,
                "ORA "  ,INDEXED,
                "ADDA"  ,INDEXED,
                "CMPX"  ,INDEXED,
                "JSR "  ,INDEXED,
                "LDX "  ,INDEXED,
                "STX "  ,INDEXED,
/* 0x00B0 */    "SUBA"  ,EXTENDED,
                "CMPA"  ,EXTENDED,
                "SBCA"  ,EXTENDED,
                "SUBD"  ,EXTENDED,
                "ANDA"  ,EXTENDED,
                "BITA"  ,EXTENDED,
                "LDA "  ,EXTENDED,
                "STA "  ,EXTENDED,
/* 0x00B8 */    "EORA"  ,EXTENDED,
                "ADCA"  ,EXTENDED,
                "ORA "  ,EXTENDED,
                "ADDA"  ,EXTENDED,
                "CMPX"  ,EXTENDED,
                "JSR "  ,EXTENDED,
                "LDX "  ,EXTENDED,
                "STX "  ,EXTENDED,
/* 0x00C0 */    "SUBB"  ,IMMEDIATE8,
                "CMPB"  ,IMMEDIATE8,
                "SBCB"  ,IMMEDIATE8,
                "ADDD"  ,IMMEDIATE16,
                "ANDB"  ,IMMEDIATE8,
                "BITB"  ,IMMEDIATE8,
                "LDB "  ,IMMEDIATE8,
                ""      ,ILLEGAL,
/* 0x00C8 */    "EORB"  ,IMMEDIATE8,
                "ADCB"  ,IMMEDIATE8,
                "ORB "  ,IMMEDIATE8,
                "ADDB"  ,IMMEDIATE8,
                "LDD "  ,IMMEDIATE16,
                ""      ,ILLEGAL,
                "LDU "  ,IMMEDIATE16,
                ""      ,ILLEGAL,
/* 0x00D0 */    "SUBB"  ,DIRECT,
                "CMPB"  ,DIRECT,
                "SBCB"  ,DIRECT,
                "ADDD"  ,DIRECT,
                "ANDB"  ,DIRECT,
                "BITB"  ,DIRECT,
                "LDB "  ,DIRECT,
                "STB "  ,DIRECT,
/* 0x00D8 */    "EORB"  ,DIRECT,
                "ADCB"  ,DIRECT,
                "ORB "  ,DIRECT,
                "ADDB"  ,DIRECT,
                "LDD "  ,DIRECT,
                "STD "  ,DIRECT,
                "LDU "  ,DIRECT,
                "STU "  ,DIRECT,
/* 0x00E0 */    "SUBB"  ,INDEXED,
                "CMPB"  ,INDEXED,
                "SBCB"  ,INDEXED,
                "ADDD"  ,INDEXED,
                "ANDB"  ,INDEXED,
                "BITB"  ,INDEXED,
                "LDB "  ,INDEXED,
                "STB "  ,INDEXED,
/* 0x00E8 */    "EORB"  ,INDEXED,
                "ADCB"  ,INDEXED,
                "ORB "  ,INDEXED,
                "ADDB"  ,INDEXED,
                "LDD "  ,INDEXED,
                "STD "  ,INDEXED,
                "LDU "  ,INDEXED,
                "STU "  ,INDEXED,
/* 0x00F0 */    "SUBB"  ,EXTENDED,
                "CMPB"  ,EXTENDED,
                "SBCB"  ,EXTENDED,
                "ADDD"  ,EXTENDED,
                "ANDB"  ,EXTENDED,
                "BITB"  ,EXTENDED,
                "LDB "  ,EXTENDED,
                "STB "  ,EXTENDED,
/* 0x00F8 */    "EORB"  ,EXTENDED,
                "ADCB"  ,EXTENDED,
                "ORB "  ,EXTENDED,
                "ADDB"  ,EXTENDED,
                "LDD "  ,EXTENDED,
                "STD "  ,EXTENDED,
                "LDU "  ,EXTENDED,
                "STU "  ,EXTENDED,

/* Here end the regular opcodes    , below follow the entries for the */
/* Page 2 and 3 codes    , these are coded as PAGE2 and PAGE3         */

/* Page 2 */


/* 0x1000 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1008 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1010 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1018 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1020 */    ""      ,ILLEGAL,
                "LBRN"  ,RELATIVE16,
                "LBHI"  ,RELATIVE16,
                "LBLS"  ,RELATIVE16,
                "LBHS"  ,RELATIVE16,
                "LBCS"  ,RELATIVE16,
                "LBNE"  ,RELATIVE16,
                "LBEQ"  ,RELATIVE16,
/* 0x1028 */    "LBVC"  ,RELATIVE16,
                "LBVS"  ,RELATIVE16,
                "LBPL"  ,RELATIVE16,
                "LBMI"  ,RELATIVE16,
                "LBGE"  ,RELATIVE16,
                "LBLT"  ,RELATIVE16,
                "LBGT"  ,RELATIVE16,
                "LBLE"  ,RELATIVE16,
/* 0x1030 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1038 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "SWI2"  ,INHERENT,
/* 0x1040 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1048 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1050 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1058 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1060 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1068 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1070 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1078 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1080 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPD"  ,IMMEDIATE16,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1088 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPY"  ,IMMEDIATE16,
                ""      ,ILLEGAL,
                "LDY"   ,IMMEDIATE16,
                ""      ,ILLEGAL,
/* 0x1090 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPD"  ,DIRECT,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1098 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPY"  ,DIRECT,
                ""      ,ILLEGAL,
                "LDY "  ,DIRECT,
                "STY "  ,DIRECT,
/* 0x10A0 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPD"  ,INDEXED,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x10A8 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPY"  ,INDEXED,
                ""      ,ILLEGAL,
                "LDY "  ,INDEXED,
                "STY "  ,INDEXED,
/* 0x10B0 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPD"  ,EXTENDED,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x10B8 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPY"  ,EXTENDED,
                ""      ,ILLEGAL,
                "LDY "  ,EXTENDED,
                "STY "  ,EXTENDED,
/* 0x10C0 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x10C8 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "LDS "  ,IMMEDIATE16,
                ""      ,ILLEGAL,
/* 0x10D0 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x10D8 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "LDS "  ,DIRECT,
                "STS "  ,DIRECT,
/* 0x10E0 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x10E8 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "LDS "  ,INDEXED,
                "STS "  ,INDEXED,
/* 0x10F0 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x10F8 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "LDS "  ,EXTENDED,
                "STS "  ,EXTENDED,


/* Page 3 */


/* 0x1100 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1108 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1110 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1118 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1120 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1128 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1130 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1138 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "SWI3"  ,INHERENT,
/* 0x1140 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1148 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1150 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1158 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1160 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1168 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1170 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1178 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1180 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPU"  ,IMMEDIATE16,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1188 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPS"  ,IMMEDIATE16,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1190 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPU"  ,DIRECT,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x1198 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPS"  ,DIRECT,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x11A0 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPU"  ,INDEXED,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x11A8 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPS"  ,INDEXED,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x11B0 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPU"  ,EXTENDED,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x11B8 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                "CMPS"  ,EXTENDED,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x11C0 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x11C8 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x11D0 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x11D8 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x11E0 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x11E8 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x11F0 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
/* 0x11F8 */    ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL,
                ""      ,ILLEGAL
};

#endif
