/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : Vectrex emulator utility functions header file             */
/*                                                                           */
/*   File Name  : UTIL.H                                                     */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This is the header file for the utility functions and      */
/*                conatins function prototypes and definitions for the utils */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    21/03/93  K.W  Creation                                        */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

#if !defined UTIL_H
    #define UTIL_H

#include <standard.h>

typedef struct DOS4GW_RMREGS
{
        T_ULONG           edi;
        T_ULONG           esi;
        T_ULONG           ebp;
        T_ULONG           reserved;
        T_ULONG           ebx;
        T_ULONG           edx;
        T_ULONG           ecx;
        T_ULONG           eax;
        T_UWORD           flags;
        T_UWORD           es,ds,fs,gs,ip,cs,sp,ss;
} DOS4GW_RMREGS;

typedef struct RealPointer
{
        T_UWORD                   Segment;
        T_UWORD                   Selector;
} REALPTR;

/* Function prototypes */

T_UCHAR     fIsWhiteSpace(T_UCHAR tData);
T_INT       fStringToWord(T_PUCHAR pcString,T_PUWORD pwResult);
T_INT       fStringToLongWord(T_PUCHAR pcString,T_PULONG plwResult);
T_INT       fHexStringToByte(T_PUCHAR pcString,T_PUCHAR pbResult);
T_SWORD     fCharToInt(T_UCHAR cWork);

T_VOID far *fDOSmalloc(REALPTR * rp,T_ULONG bytes_to_allocate);
T_VOID      fDOSfree(REALPTR * rp);

#endif

/* End of UTIL.H */


