/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : Vectrex emulator debugging functions header file           */
/*                                                                           */
/*   File Name  : VDEBUG.H                                                   */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file contains header file information for the         */
/*                vectrex debugging functions.                               */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    15/03/93  K.W  Creation of empty file and descriptions         */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

#if !defined VDEBUG_H
#define VDEBUG_H

#include <standard.h>

#include "io.h"

/* Defines for debug */
#define VERROR  3
#define HIGH    2
#define MED     1
#define MID     1
#define LOW     0

// 0 not allowed here, used by dispatcher
// Define window information structure


/* Define function prototyoes */
T_INT      fDebugInit(T_VOID);
T_SWORD    fDebugXX(T_PUBYTE pcDebugString,...);
T_INT      open_debug_window(T_VOID);
T_VOID     close_debug_window(T_VOID);
//T_VOID     fDebugToggle(T_UWORD tKeyPress);
//T_VOID     fDebugFileToggle(T_UWORD tKeyPress);
//T_VOID     fDebugLevelLow(T_UWORD tKeyPress);
//T_VOID     fDebugLevelMid(T_UWORD tKeyPress);
//T_VOID     fDebugLevelHigh(T_UWORD tKeyPress);

#define  fDebug(level,body) ((T_VOID)0)
//#define  fDebug(level,body)

extern T_INT   DebugWinId;
extern WININFO asDbgWin[RESOLUTION_COUNT];

#endif
