/*****************************************************************************/
/*                                                                           */
/*   VECTREX HP3000 Software Emulator              Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : Vectrex HP3000 Emulator Main Header file                   */
/*                                                                           */
/*   File Name  : VECTREX.H                                                  */
/*                                                                           */
/*   Author     : Keith Wilkins / C.S.                                       */
/*                                                                           */
/*   Version    : 1.20                                                       */
/*                                                                           */
/*   Desciption : This is the main header file for the vectrex emulator it   */
/*                inlcudes all of the headers that any vectrex emulator      */
/*                module could possibly require in the way of function       */
/*                prototypes and externals.                                  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    13/03/93  K.W  Creation                                        */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*    1.20    20/10/96  C.S  DVE V1.2                                        */
/*                                                                           */
/*****************************************************************************/

#ifndef VECTREX_H
#define VECTREX_H

#include <standard.h>

/*********************/
/* Base declarations */
/*********************/
#define STRING_LENGTH  256 //

#define ONE_PASS 0
#define ENDLESS 1


#define EMU_RUN 3
#define EMU_RESTART 2
#define EMU_FAULT 1
#define EMU_DONE 0

#define IMAGER_DRAW_OVERLAY 256
#define IMAGER_DRAW_NOTHING 257
#define IMAGER_DRAW_COLOR_13 (13*16)
#define IMAGER_DRAW_COLOR_12 (12*16)

#define IMAGER_DRAW_WHEEL_COLOR_1 (13*16)
#define IMAGER_DRAW_WHEEL_COLOR_2 (11*16)
#define IMAGER_DRAW_WHEEL_COLOR_3 (12*16)

typedef struct inientry
{
   T_SWORD   tType;
   T_CHAR    *acNameTag;
   T_VOID    *pvLocation;
}INIFILEENTRY;

/***********************/
/* Function prototypes */
/***********************/
T_INT   fSystemReset(T_VOID);
T_INT   fSystemInit(T_VOID);
T_INT   write_ini(T_VOID);
T_VOID  set_functions(T_VOID);
T_INT vdefault_tasten_funktion(PARAMETER *parameter);

extern T_ULONG        imager_pulse_ticks;
extern T_UWORD        ImagerColorNow;
extern T_ULONG        lwGblWheelTicks;
extern T_SWORD        wGblImagerXOffset1;
extern T_SWORD        wGblImagerXOffset2;
extern T_SWORD        wGblImagerXOffset;

extern T_UWORD        wGblColor1Degrees;
extern T_UWORD        wGblColor2Degrees;
extern T_UWORD        wGblColor3Degrees;
extern T_UWORD        wGblImagerMode;
extern T_INT          bGblGoggleGame;
extern T_INT          bGblForceSingleProcessor;
extern T_INT          bGblForceVesa12;
extern T_INT          bGblDebugEnable;
extern T_INT          bGblDebugFileEnable;
extern T_SWORD        tGblDebugLevel;
extern T_SWORD        tGblDebugMsgLevel;
extern T_INT          bGblDebugMonitorEnable;
extern T_INT          bGblRestoreOnStart;
extern T_INT          bGblSaveOnExit;
extern T_UWORD        wGblPCJoystick; // 0 no (then keyboard) 1 = digital, 2 = analolg
extern T_INT          bGblExtendedRam;
extern T_INT          bGblNoShades;
extern T_INT          bGblLoadColorsExact;
extern T_UWORD        wGblQuitFlag;
extern T_INT          bGblStatsValid;
extern T_ULONG        lwGblSystemTickTotal;
extern T_ULONG        lwGblSystemTickBreakpoint;
extern T_INT          bGblDisplayEnable;
extern T_INT          bGblDisplayAutoRefresh;
extern T_INT          bGblDisplayEnhance;
extern T_INT          bGblDisplayFullRefresh;
extern T_INT          bGblDisplayVerbose;
extern T_INT          bGblDisplayExactScaling;
extern T_SLONG        lwGblDisplayTickReload;
extern T_ULONG        lwGblDisplayTickMax;
extern T_ULONG        lwGblDisplayTickMin;
extern T_SLONG        lwGblDisplayTickCounter;
extern T_UWORD        wGblDisplayLinePeriod;
extern T_UWORD        wGblDisplayBaseColour;
extern T_INT          bGblOverlayEnable;
extern T_INT          bGblOverlayEnable_reset;
extern T_INT          bGblLightpenEnable; // read in *.vol file, default: false
extern T_SLONG        lwGblClipX;
extern T_SLONG        lwGblClipY;
extern T_SLONG        lwGblClipX_reset;
extern T_SLONG        lwGblClipY_reset;
extern T_UWORD        wGblseal_audio_device;
extern T_UWORD        wGblSound;
extern T_UWORD        wGblDigitalVolume;
extern T_SLONG        lwGblMaxTicks;
extern T_INT          bGblCartridgeROMWriteEnable;
extern T_INT          bGblSystemROMWriteEnable;
extern T_UWORD        wGblPly1Button1;
extern T_UWORD        wGblPly1Button2;
extern T_UWORD        wGblPly1Button3;
extern T_UWORD        wGblPly1Button4;
extern T_UWORD        wGblPly1JoystkUp;
extern T_UWORD        wGblPly1JoystkDn;
extern T_UWORD        wGblPly1JoystkLf;
extern T_UWORD        wGblPly1JoystkRt;

extern T_UWORD        wGblPly2Button1;
extern T_UWORD        wGblPly2Button2;
extern T_UWORD        wGblPly2Button3;
extern T_UWORD        wGblPly2Button4;

extern T_UWORD        wGblPly2JoystkUp;
extern T_UWORD        wGblPly2JoystkDn;
extern T_UWORD        wGblPly2JoystkLf;
extern T_UWORD        wGblPly2JoystkRt;

extern T_INT          bGblDigitalJoystick;
extern T_SWORD        wGblJoystickSensitivity;
extern T_INT          bGblJoystickAutoCentre;

extern T_UWORD        wGblDisplayMode;

extern T_UCHAR        acGblROMImageFileName[STRING_LENGTH];
extern T_UCHAR        acGblRAMImageFileName[STRING_LENGTH];
extern T_UCHAR        acGblDefaultCartFileName[STRING_LENGTH];

extern T_UCHAR        acGblCartCarousel[12][STRING_LENGTH];

extern T_ULONG        lwGblTicksToGrab;
extern T_UWORD        enable_event;
extern T_INT          reset_state;
extern T_INT          bGblGUIEnable;

extern T_SWORD        wGblXDrift;
extern T_SWORD        wGblYDrift;
extern T_SWORD        wGblXIntegrator;
extern T_SWORD        wGblYIntegrator;


extern T_INT          bGblPauseMode;
extern UPDATE_FUNCTION *vectrex_update;

extern T_UCHAR GblBinDir[STRING_LENGTH];
extern T_UCHAR GblVolDir[STRING_LENGTH];
extern T_UCHAR GblPicDir[STRING_LENGTH];
extern T_UCHAR GblSvgDir[STRING_LENGTH];
extern T_UCHAR GblDevDir[STRING_LENGTH];

#define V_DO_NOTHING 0
#define V_LOAD_CARTRIDGE 1
#define V_LOAD_SAVED_GAME 2
#define V_QUIT 3
#define V_REBOOT 4
extern T_INT  action_after_execution;
extern T_INT  init_after_execution;
extern T_INT  load_var;
extern T_INT pause_on_monitor_entry_default;
extern T_INT  sthwkptch;
extern T_INT gblException;

#define T_NORMAL 0
#define T_ANTI_ALIASED 1

extern T_INT blinetype;

#endif

