/*****************************************************************************/
/*                                                                           */
/*   ERROR Handler                                 Copyright K.Wilkins 1996  */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Title      : Library function error handler                             */
/*                                                                           */
/*   File Name  : ERROR.C                                                    */
/*                                                                           */
/*   Author     : Keith Wilkins                                              */
/*                                                                           */
/*   Version    : 1.00                                                       */
/*                                                                           */
/*   Desciption : This file contains the functions for the Vectrex debugging */
/*                functions                                                  */
/*                                                                           */
/*   Functions  : fFatal()              - Fatal non-return error handler     */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*   Revision History:                                                       */
/*                                                                           */
/*   Version    Date    Who  Description of changes                          */
/*   -------    ----    ---  ----------------------                          */
/*                                                                           */
/*    0.01    15/03/93  K.W  Creation of empty file and descriptions         */
/*    1.00    05/08/96  K.W  Public release of DVE V1.0                      */
/*                                                                           */
/*****************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>

#include <standard.h>

#include "io.h"
#include "sound.h"
//#include "keyboard.h"
#include "error.h"

#define  VARG_BUFF_SIZE    1024

/*****************************************************************************/
/*                                                                           */
/*   Function    : fFatal()                                                  */
/*                                                                           */
/*   Author      : K.W                                                       */
/*                                                                           */
/*   Description : Fatal non-returnable error handler.                       */
/*                                                                           */
/*   Accepts     : BYTE tLevel, char *Text with formatting                   */
/*                                                                           */
/*   Returns     : Nothing                                                   */
/*                                                                           */
/*****************************************************************************/


T_VOID fFatal(T_PUCHAR pcString,...)
{
 static T_UCHAR acTextBuffer[VARG_BUFF_SIZE];
 va_list      tGlop;
 /* Expand the varable argument list into the text buffer */
 va_start(tGlop,pcString);                /* Initialise the variable array */
 if (vsprintf(acTextBuffer,pcString,tGlop)==-1)
 {
  strcpy(acTextBuffer,"fFatal() Text buffer overflow");
 }
 va_end(tGlop);
 if (DoneTimerHandler!=NULL)
  DoneTimerHandler();
 if (fSoundRestore!=NULL)
  fSoundRestore();
 fKBDrestore();
 fIORestore();
 flushall();
 fprintf(stderr,"\nERROR : %s\n",acTextBuffer);
 exit(0);
}
